function RNLTV_inpainting_Fig11_word
%
%setup the path
curDir=pwd; %Identify current folder

addessFolder = strjoin({curDir,'img_png_NLTV'},filesep);
path(addessFolder,path);

application.name = 'inpainting';

ExpFolderName = 'results';
patialMaskName = 'word';
imgResultFolder = ['' patialMaskName];

ExpFolderPath = strjoin({curDir,ExpFolderName,application.name,imgResultFolder},filesep);
if ~exist(ExpFolderPath , 'dir')
    mkdir(ExpFolderPath );
end

fileName_array = {'boat120','barbara120', 'fingerprint2120'};

nbIter = 3000;
radius = 5;
init = 33;

application.data_term = 2;

gama = 3;
lambda  = 5000;
mu=0.8;
hsigma=0.05;

for i_fileName = 1:length(fileName_array)
    fileName = fileName_array{i_fileName};
    
    ExpSubfolderPath = strjoin({ExpFolderPath,fileName},filesep);
    if ~exist( ExpSubfolderPath, 'dir')
        mkdir( ExpSubfolderPath);
    end
    
    [in_clean,map] = imread([fileName,'.png']);
    in_clean = double(in_clean); in_clean = in_clean/ max(in_clean(:));
    
    load([patialMaskName,'_miss_data.mat']);
    
    
    in_polluted = in_clean.*miss_data;
    
    application.miss_data = miss_data;
    rng(8,'twister');
    
    [u,v,energies] = regularized_NLTV(in_polluted,nbIter,radius,mu,...
        lambda,gama, hsigma, init, application);
    psnr = psnr1(u,in_clean)
    
    imgResultNameFolderPath = strjoin({ExpSubfolderPath,...
        [fileName,'_',patialMaskName]},filesep);
    
    % save image results
    save([imgResultNameFolderPath '_u_.mat'],'u');
end